﻿//////////////////////////////////////////////
// MaterialManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class Material ;
	class System ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

#include "MaterialType.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <string>
#include <unordered_map>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT MaterialManager final : public nkCommon::MaybeSingletonClass<MaterialManager>
	{
		public :

			// Destructor
			virtual ~MaterialManager () ;

			// Management
			Material* createOrRetrieve (nkMemory::StringView name, MATERIAL_TYPE type) ;
			Material* record (nkMemory::StringView name, nkMemory::UniquePtr<Material> resource) ;
			Material* get (nkMemory::StringView name) ;
			Material* getByIndex (unsigned int id) ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;
			nkMemory::UniquePtr<Material> relinquish (nkMemory::StringView name) ;

		private :

			// Functions
			// Constructor, destructor
			MaterialManager (bool isSingleton) noexcept ;
			MaterialManager (System* system) noexcept ;
			MaterialManager (const MaterialManager&) = delete ;
			MaterialManager (MaterialManager&&) = delete ;

			// Operators
			MaterialManager& operator= (const MaterialManager&) = delete ;
			MaterialManager& operator= (MaterialManager&&) = delete ;
			
		private :

			// Attributes
			std::unordered_map<std::string, nkMemory::UniquePtr<Material>> _memory ;
			System* _system ;

		private :

			friend class nkCommon::MaybeSingletonClass<MaterialManager> ;
			friend class System ;
	} ;
}